% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgwnbr.R
\name{mgwnbr}
\alias{mgwnbr}
\title{Multiscale Geographically Weighted Negative Binomial Regression}
\usage{
mgwnbr(
  data,
  formula,
  long,
  lat,
  band_method,
  band_criterion = "cv",
  distribution = "negbin",
  globalmin = TRUE,
  multiscale = TRUE,
  distancekm = FALSE,
  weight = NULL,
  offset = NULL,
  id = NULL,
  h = NULL,
  max_int = 50,
  tol = 10^-307
)
}
\arguments{
\item{data}{name of the dataset.}

\item{formula}{regression model formula as in \code{lm}.}

\item{long}{name of the variable containing the longitudes in the dataset.}

\item{lat}{name of the variable containing the latitudes in the dataset.}

\item{band_method}{indicates the method to be used for the bandwidth calculation (\code{adaptive_bsq}, \code{fixed_bsq}, \code{fixed_g}).}

\item{band_criterion}{indicates the criterion to be used for the bandwidth calculation (\code{cv}, \code{aic}), default value is \code{"cv"}.}

\item{distribution}{indicates the probability distribution to be used for the regression (\code{gaussian}, \code{poisson}, \code{negbin}, \code{logistic}), default value is\code{"negbin"}.}

\item{globalmin}{logical value indicating whether to find a global minimum in the optimization process, default value is \code{TRUE}.}

\item{multiscale}{logical value indicating if multiscale should be used (\code{TRUE}, \code{FALSE}), default value is \code{TRUE}.}

\item{distancekm}{logical value indicating whether to calculate the distances in km, default value is \code{FALSE}.}

\item{weight}{name of the variable containing the sample weights, default value is \code{NULL}.}

\item{offset}{name of the variable containing the offset values, if null then is set to a vector of zeros, default value is \code{NULL}.}

\item{id}{name of the variable containing the unique identifier of the observations in the dataset, default value is \code{NULL}.}

\item{h}{integer indicating a predetermined bandwidth value, default value is \code{NULL}.}

\item{max_int}{integer indicating the number of iterations, default value is \code{50}.}

\item{tol}{numeric value indicating the tolerance for small determinants not being considered zero when calculating inverse matrices throughout the model execution, default value is \code{10^-307}.}
}
\value{
A list that contains:

\itemize{
\item \code{band} - Bandwidth values for each covariate.
\item \code{fitted_values} - MGWR fitted values.
\item \code{mgwr_param_estimates} - MGWR parameter estimates.
\item \code{mgwr_se} - MGWR standard errors.
\item \code{general_bandwidth} - General bandwidth value.
\item \code{measures} - Goodness of fit statistics.
\item \code{ENP} - Effective number of parameters.
\item \code{alpha_level_5_pct} - significance levels for the t tests on parameter significance.
\item \code{t_critical} - Critical values for the t tests on parameter significance.
\item \code{global_param_estimates} - Parameter estimates for the global model.
\item \code{t_test_dfs} - Denominator degrees of freedom for the t tests.
\item \code{global_measures} - Goodness of fit statistics for the global model.
}
}
\description{
Fits a geographically weighted regression model with different scales for each covariate. Uses the negative binomial distribution as default, but also accepts the normal, Poisson, or logistic distributions. Can fit the global versions of each regression and also the geographically weighted alternatives with only one scale, since they are all particular cases of the multiscale approach.
}
\examples{
## Data

data(georgia)

## MGWR Model

mod <- mgwnbr(data=georgia, formula=PctBach~PctBlack+PctFB,
              lat="Y", long="X", globalmin=FALSE, band_method="adaptive_bsq", band_criterion="cv",
              distribution="gaussian", multiscale=TRUE, h=100)

## Bandwidths
mod$general_bandwidth

## Goodness of fit measures
mod$measures

## GWNBR Model

\dontrun{
mod <- mgwnbr(data=georgia, formula=PctBach~PctBlack+PctFB,
              lat="Y", long="X", globalmin=FALSE, band_method="adaptive_bsq", band_criterion="cv",
              distribution="negbin", multiscale=FALSE)
}

## GWPR Model

\dontrun{
mod <- mgwnbr(data=georgia, formula=PctBach~PctBlack+PctFB,
              lat="Y", long="X", globalmin=FALSE, band_method="adaptive_bsq", band_criterion="cv",
              distribution="poisson", multiscale=FALSE)
}

}
