% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_treatment.R
\name{add_treatment}
\alias{add_treatment}
\alias{generate_treatment_list}
\alias{ask_treatment_list}
\alias{match_treatment}
\title{Add treatment metadata}
\usage{
add_treatment(
  input_data,
  treatment_list = NULL,
  ask_treatment_list = TRUE,
  ...
)

generate_treatment_list(treatment_labels, direction)

ask_treatment_list(direction = c("horizontal", "vertical"))

match_treatment(well_position, treatment_list)
}
\arguments{
\item{input_data}{A data frame with well positions and their corresponding values.}

\item{treatment_list}{A list containing treatment information}

\item{ask_treatment_list}{A boolean parameter indicating whether treatment labels should be retrieved via user prompt (default) or not.}

\item{...}{Additional arguments to be passed to \code{\link{ask_treatment_list}}.}

\item{treatment_labels}{A character vector containing treatment labels.}

\item{direction}{A character vector specifying the orientation of the plate layout. 
It can be either "horizontal" or "vertical".}

\item{well_position}{The sample position(s) to check}
}
\value{
\code{add_treatment} returns a data frame with treatment information added.

\code{generate_treatment_list} returns a list of treatment labels where each level is assigned to a corresponding 
        row or column based on the selected direction parameter.

\code{ask_treatment_list} returns a list containing plate axes as keys and treatment labels as values.

\code{match_treatment} returns the corresponding treatment labels if sample position matches treatment criteria, "NA" otherwise
}
\description{
\code{add_treatment} adds treatment metadata to photometer data that is specified in long format.
For this function to work properly, the column containing the well positions should be named 'Position'
and the column containing the corresponding absorption values should be named 'Values'.

\code{generate_treatment_list} generates a list of provided treatment labels mapped to the user-specified
plate layout. The plate layout is based on a 96-well plate and can be either horizontal (i.e. letters A-H) or vertical (i.e. numbers 1-12).

\code{ask_treatment_list} works the same way as \code{generate_treatment_list}, but retrieves the
treatment labels based on a user prompt instead of user-set parameters. The plate axis can be either in horizontal direction
providing letters A-H or in vertical direction providing numbers 1-12 based on a 96-well plate layout.

\code{match_treatment} maps treatment labels to corresponding well positions and returns 'NA' otherwise.
}
\details{
\code{generate_treatment_list} checks if the length of treatment_labels matches the specified 
number of rows or columns based on the direction parameter. If not, it throws an error.
If the lengths match, it generates a list of treatment_labels where each label is 
assigned to a corresponding row or column based on the direction parameter.
}
\seealso{
\code{\link{generate_experiment_list}}, \code{\link{ask_experiment_list}},
\code{\link{generate_group_list}}, \code{\link{ask_group_list}},
\code{\link{add_concentration}}, \code{\link{validate_cells}}
}
