% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-detect_iron_deficiency.R
\name{detect_iron_deficiency_u5}
\alias{detect_iron_deficiency_u5}
\alias{detect_iron_deficiency_5over}
\alias{detect_iron_deficiency}
\alias{detect_iron_deficiency_qualitative}
\title{Determine iron storage status}
\usage{
detect_iron_deficiency_u5(ferritin = NULL, label = TRUE)

detect_iron_deficiency_5over(ferritin = NULL, label = TRUE)

detect_iron_deficiency(ferritin = NULL, group = c("u5", "5over"), label = TRUE)

detect_iron_deficiency_qualitative(
  ferritin = NULL,
  inflammation = NULL,
  group = c("u5", "5over"),
  label = TRUE
)
}
\arguments{
\item{ferritin}{A numeric value or numeric vector of serum ferritin level in
micrograms per litre (microgram/L).}

\item{label}{Logical. Should labels be used to classify iron storage status?
If TRUE (default), status is classified as "no iron deficiency" or
"iron deficiency". If FALSE, simple integer codes are returned: 0 for
no iron deficiency and 1 for iron deficiency.}

\item{group}{A character value specifying the population target group to
determine iron status from. Can be either for under 5 year old ("u5") or
5 years and over ("5over"). Default to "u5".}

\item{inflammation}{Logical value or vector. Is subject in inflammation or
not?}
}
\value{
If \code{label} is TRUE, a character value or character vector of iron
status classification (can be either "iron deficiency" or "no iron
deficiency"). If \code{label} is FALSE, an integer value or integer vector of
iron status classification (0 = no iron deficiency; 1 = iron deficiency)
}
\description{
Given serum ferritin values, determine iron storage status.
}
\examples{
 # Iron storage status based on CRP only
 ferritin_corrected <- correct_ferritin(
   crp = mnData$crp, ferritin = mnData$ferritin
 )
 detect_iron_deficiency(ferritin_corrected)

 # Iron storage status based on AGP only
 ferritin_corrected <- correct_ferritin(
   agp = 2, ferritin = mnData$ferritin[1]
 )
 detect_iron_deficiency(ferritin_corrected)

 # Iron storage status based on CRP and AGP
 ferritin_corrected <- correct_ferritin(
   crp = mnData$crp[1], agp = 2, ferritin = mnData$ferritin[1]
 )
 detect_iron_deficiency(ferritin_corrected)

 # Iron storage status - qualitative
 detect_iron_deficiency_qualitative(
   ferritin = 3, inflammation = TRUE
 )
 detect_iron_deficiency_qualitative(
   ferritin = c(2, 3, 5), inflammation = c(TRUE, FALSE, TRUE)
 )

}
\author{
Nicholus Tint Zaw and Ernest Guevarra
}
