% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clm.R
\name{clm}
\alias{clm}
\alias{vcov.clm}
\alias{summary.clm}
\title{Constrained least squares}
\usage{
clm(x, R, q = NULL)

\method{vcov}{clm}(object, ...)

\method{summary}{clm}(object, ...)
}
\arguments{
\item{x}{a linear model fitted by \code{lm},}

\item{R}{a matrix of constrains (one line for each constrain, one
column for each coefficient),}

\item{q}{an optional vector of rhs values (by default a vector of
0)}

\item{object}{a \code{clm} object for the \code{summary} and the \code{vcov}
methods}

\item{\dots}{further arguments}
}
\value{
an object of class \code{clm} which inherits from class \code{lm}
}
\description{
Compute the least squares estimator using linear constrains on the
coefficients.
}
\examples{
# Cobb-Douglas production function for the apple data set
# First compute the total production
apples <- apples |> transform(prod = apples + otherprod)
# unconstrained linear model
cd <- lm(log(prod) ~ log(capital) + log(labor) +
         log(materials), apples)
# constrained linear model imposing constant
# return to scales
crs <- clm(cd, R = matrix(c(0, 1, 1, 1), nrow = 1),
               q = 1)
}
\keyword{models}
