% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fa.sglfit.R
\name{predict.fa.sglfit}
\alias{predict.fa.sglfit}
\title{Computes prediction}
\usage{
\method{predict}{fa.sglfit}(object, newx, s = c("lam.min", "lam.1se"), type = c("response"), ...)
}
\arguments{
\item{object}{fitted \code{\link{fa.sglfit}} model object.}

\item{newx}{matrix of new values for x at which predictions are to be made. NOTE: \code{newx} must be a matrix, predict function does not accept a vector or other formats of newx. In addition, note that x should be binded with columns of out-of-sample factors.}

\item{s}{choose between 'lam.min' and 'lam.1se'.}

\item{type}{type of prediction required. Only response is available. Gives predicted response for regression problems.}

\item{...}{Not used. Other arguments to predict.}

\item{method}{choose between 'single', 'pooled', and 'fe'.}
}
\value{
The object returned depends on type.
}
\description{
Similar to other predict methods, this functions predicts fitted values from a fitted sglfit object.
}
\details{
\code{s} is the new vector at which predictions are to be made. If s is not in the lambda sequence used for fitting the model, the predict function will use linear interpolation to make predictions. The new values are interpolated using a fraction of predicted values from both left and right \eqn{lambda} indices.
}
