% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numeric_encoder.R
\name{numeric.encoder}
\alias{numeric.encoder}
\alias{numeric.frame}
\title{Encoder for Quantitative Variables}
\usage{
numeric.encoder(
  x,
  k,
  type = 1L,
  encoding.digits = NULL,
  tag = "x",
  frame = NULL,
  weights = NULL
)

numeric.frame(
  reps = NULL,
  breaks = NULL,
  type = NULL,
  encoding.digits = NULL,
  tag = "x"
)
}
\arguments{
\item{x}{a numeric vector to be encoded.}

\item{k}{an integer specifying the coarseness of the encoding. If not positive, all unique values of \code{x} are used as knots or bins.}

\item{type}{an integer (\code{1} or \code{0}) specifying the encoding method (see the "details" section).}

\item{encoding.digits}{an integer specifying the rounding digits for the piecewise linear encoding (\code{type = 1}).}

\item{tag}{the name of the variable.}

\item{frame}{a "numeric.frame" object or a numeric vector that explicitly defines the knots or breakes for the encoding.}

\item{weights}{an optional numeric vector of sample weights for \code{x}.}

\item{reps}{a numeric vector to be used as the representative values (knots).}

\item{breaks}{a numeric vector to be used as the binning breaks.}
}
\value{
\code{numeric.encoder()} returns an object of class "encoder". This is a list containing the following components:
\item{frame}{a "numeric.frame" object containing the encoding information.}
\item{encode}{a function to convert a numeric vector \code{x} into a dummy matrix.}
\item{n}{the number of encoding levels (i.e., columns in the design matrix).}
\item{type}{a character string describing the encoding type: "linear", "constant", or "null".}

\code{numeric.frame()} returns a "numeric.frame" object containing the encoding information.
}
\description{
\code{numeric.encoder()} creates an encoder function for a quantitative variable.
This encoder can then be used to convert a numeric vector into a design matrix using either piecewise linear or one-hot interval encoding, which are core components for modeling effects in a MID model.

\code{numeric.frame()} is a helper function to create a "numeric.frame" object that defines the encoding scheme.
}
\details{
The primary purpose of the encoder is to transform a single numeric variable into a design matrix for the MID model's linear system formulation.
The output of the encoder depends on the \code{type} argument.

When \code{type = 1}, the variable's effect is modeled as a piecewise linear function with \code{k} knots including both ends.
For each value, the encoder finds the two nearest knots and assigns a weight to each, based on its relative position.
This results in a design matrix where each row has at most two non-zero values that sum to \code{1}.
This approach creates a smooth, continuous representation of the effect.

When \code{type = 0}, the variable's effect is modeled as a step function by dividing its range into \code{k} intervals (bins).
The encoder determines which interval each value falls into and assigns a \code{1} to the corresponding column in the design matrix, with all other columns being \code{0}.
This results in a standard one-hot encoded matrix and creates a discrete, bin-based representation of the effect.
}
\examples{
# Create an encoder for a quantitative variable
data(iris, package = "datasets")
enc <- numeric.encoder(x = iris$Sepal.Length, k = 5L, tag = "Sepal.Length")
enc

# Encode a numeric vector with NA and Inf
enc$encode(x = c(4:8, NA, Inf))

# Create an encoder with a pre-defined encoding frame
frm <- numeric.frame(breaks = c(3, 5, 7, 9), type = 0L)
enc <- numeric.encoder(x = iris$Sepal.Length, frame = frm)
enc$encode(x = c(4:8, NA, Inf))

# Create an encoder with a numeric vector specifying the knots
enc <- numeric.encoder(x = iris$Sepal.Length, frame = c(3, 5, 7, 9))
enc$encode(x = c(4:8, NA, Inf))
}
\seealso{
\code{\link{factor.encoder}}
}
