% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miebl_re.R
\name{miebl_re}
\alias{miebl_re}
\title{Creates a report for a specific performance criterion from a miebl output}
\usage{
miebl_re(mb, X = nrow(mb) - 1, mc = 100)
}
\arguments{
\item{mb}{object produced by miebl}

\item{X}{Number of correct responses for the performance criterion}

\item{mc}{performance criterion expressed as percent e.g. 90\% performance criterion is 90}
}
\value{
a report on the performance criterion selected with respect to the true mastery level desired
}
\description{
Creates a report for a specific performance criterion from a miebl output
}
\examples{
#create a miebl output for default 90\% desired true mastery
xx<-miebl(10)
#Uses the miebl output for miebl_re for 90\% performance criterion
miebl_re(xx,mc=90)
}
