% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_sr.R
\name{net_sr}
\alias{net_sr}
\title{Estimate net migration from survival ratios applied to lifetime migration data}
\usage{
net_sr(
  .data,
  pop0_col = "pop0",
  pop1_col = "pop1",
  survival_ratio_col = "sr",
  net_children = FALSE,
  maternal_exposure = c(0.25, 0.75),
  maternal_age_id = 4:9,
  maternal_col = pop1_col
)
}
\arguments{
\item{.data}{A data frame with two rows with the total number of lifetime in- and out-migrants in separate columns. The first row contains totals at the first time point and second row at the second time point.}

\item{pop0_col}{Character string name of column containing name of initial populations. Default \code{"pop0"}.}

\item{pop1_col}{Character string name of column containing name of end populations. Default \code{"pop1"}.}

\item{survival_ratio_col}{Character string name of column containing survivor ratios. Default \code{"sr"}.}

\item{net_children}{Logical to indicate if to estimate net migration when no survival ratio exists. Default \code{FALSE}.}

\item{maternal_exposure}{Vector for maternal exposures to interval to be used to estimate net migration for each of the unknown children age groups. Length should correspond to the number of children age groups where net migration estimates are required.}

\item{maternal_age_id}{Row numbers to indicate which rows correspond to maternal age groups at the end of the period.}

\item{maternal_col}{Name of maternal population column, required for the estimation of net migration of children.}
}
\value{
Data frame with estimates of net migration
}
\description{
Using survival ratios to estimate net migration from lifetime migration data
}
\examples{
# results to match un manual 1984 (table 24)
net_sr(bombay_1951, pop0_col = "pop_1941", pop1_col = "pop_1951")
  
# results to match Bogue, Hinze and White (1982)
library(dplyr)
alabama_1970 \%>\%
  filter(race == "white", sex == "male") \%>\%
  select(-race, -sex) \%>\%
  group_by(age_1970) \%>\%
  net_sr(pop0_col = "pop_1960", pop1_col = "pop_1970", 
         survival_ratio_col = "us_census_sr")
         
# results to match UN manual 1992 (table 6)
net_sr(manila_1970, pop0_col = "pop_1960", pop1_col = "pop_1970", 
       survival_ratio_col = "phl_census_sr")
       
# with children net migration estimate
net_sr(manila_1970, pop0_col = "pop_1960", pop1_col = "pop_1970", 
       survival_ratio_col = "phl_census_sr", net_children = TRUE)
}
\references{
Bogue, D. J., Hinze, K., & White, M. (1982). Techniques of Estimating Net Migration. Community and Family Study Center. University of Chicago.
}
