#' Gets matrices of medians for each individual sample for all measured parameters for all clusters
#'
#' Gets matrices of medians for each individual sample for all measured parameters for all clusters
#'
#' @param citrus.combinedFCSSet loaded from citrusClustering.RData file generated by Citrus run
#' @param citrus.foldClustering loaded from citrusClustering.RData file generated by Citrus run
#' @param citrus.foldFeatureSet computed from first two variables using citrus.calculateFoldFeatureSet function from citrus package
#'
#' @return Returns a list with each element corresponding to a matrix (rows as samples, columns as measured parameters) for a different cluster (for the minimum threshold specified)
#'
#' @examples
#' library(mineCitrus)
#' data("citrus.combinedFCSSet")
#' data("citrus.foldClustering")
#' data("citrus.foldFeatureSet")
#' meds<-allmeds(citrus.combinedFCSSet=citrus.combinedFCSSet,
#'               citrus.foldClustering=citrus.foldClustering,
#'               citrus.foldFeatureSet=citrus.foldFeatureSet)
#'
#' @export
allmeds<-function(citrus.combinedFCSSet,citrus.foldClustering,citrus.foldFeatureSet){
  parnames<-colnames(citrus.combinedFCSSet$data)
  clust<-citrus.foldClustering$allClustering$clusterMembership
  data<-citrus.combinedFCSSet$data
  ind<-grep("fileId",parnames)
  signals<-list()
  index<-1
  for(i in citrus.foldFeatureSet$allLargeEnoughClusters){
    signals[[index]]<-aggregate(data[clust[[i]],],by=list(data[clust[[i]],ind]),FUN=median)
    index<-index+1
  }
  names(signals)<-citrus.foldFeatureSet$allLargeEnoughClusters
  return(signals)
}
