#' Gets matrix of medians for desired measured features for all clusters meeting threshold requirements specified in Citrus
#'
#' Gets matrix of medians for desired measured features for all clusters meeting threshold requirements specified in Citrus
#'
#' @param citrus.combinedFCSSet loaded from citrusClustering.RData file generated by Citrus run
#' @param citrus.foldClustering loaded from citrusClustering.RData file generated by Citrus run
#' @param citrus.foldFeatureSet computed from first two variables using citrus.calculateFoldFeatureSet function from citrus package
#' @param medsofinterest The names of the columns from citrus.combinedFCSSet$data of interest to extract medians for
#'
#' @return Returns a matrix with columns corresponding to selected features and rows corresponding to samples
#' @examples
#' library(mineCitrus)
#' data("citrus.combinedFCSSet")
#' data("citrus.foldClustering")
#' data("citrus.foldFeatureSet")
#' medians<-clustermeds(citrus.foldFeatureSet=citrus.foldFeatureSet,
#'                      citrus.foldClustering=citrus.foldClustering,
#'                      medsofinterest=c("Red","Blue"),
#'                      citrus.combinedFCSSet=citrus.combinedFCSSet)
#'
#' @export
clustermeds<-function(citrus.foldFeatureSet,citrus.foldClustering,medsofinterest,citrus.combinedFCSSet){
  #fun was copied from https://github.com/nolanlab/citrus/blob/master/R/citrus.plot.R to avoid needing to import the Citrus library
  fun = function(clusterId,clusterAssignments,clusterCols,data){
    apply(data[clusterAssignments[[clusterId]],clusterCols],2,median)
  }
  clusterMedians = t(sapply(citrus.foldFeatureSet$allLargeEnoughClusters,fun,clusterAssignments=citrus.foldClustering$allClustering$clusterMembership,data=citrus.combinedFCSSet$data,clusterCols=medsofinterest))
  rownames(clusterMedians) = citrus.foldFeatureSet$allLargeEnoughClusters
  return(clusterMedians)
}

