% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classclustermeds.R
\name{classclustermeds}
\alias{classclustermeds}
\title{Gets matrices of medians for each individual sample for all measured parameters for all clusters}
\usage{
classclustermeds(citrus.foldFeatureSet, citrus.foldClustering,
  citrus.combinedFCSSet, groupsizes, meds)
}
\arguments{
\item{citrus.foldFeatureSet}{computed from first two variables using citrus.calculateFoldFeatureSet function from citrus package}

\item{citrus.foldClustering}{loaded from citrusClustering.RData file generated by Citrus run}

\item{citrus.combinedFCSSet}{loaded from citrusClustering.RData file generated by Citrus run}

\item{groupsizes}{list of sizeso f the groups run in Citrus, in order of the selection for citrus run}

\item{meds}{The names of the columns from citrus.combinedFCSSet$data of interest to extract medians for}
}
\value{
Returns a list of matrices with columns corresponding to selected features and rows corresponding to sample groups;
each list element corresponds to data for a different cluster
}
\description{
Gets matrices of medians for each individual sample for all measured parameters for all clusters
}
\examples{
library(mineCitrus)
data("citrus.combinedFCSSet")
data("citrus.foldClustering")
data("citrus.foldFeatureSet")
meds<-allmeds(citrus.combinedFCSSet=citrus.combinedFCSSet,
              citrus.foldClustering=citrus.foldClustering,
              citrus.foldFeatureSet=citrus.foldFeatureSet)
medians<-classclustermeds(citrus.foldFeatureSet,citrus.foldClustering,
                          citrus.combinedFCSSet,groupsizes=c(10,10),meds=meds)

}
