% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimalistGODB.R
\name{buildGODatabaseDriver}
\alias{buildGODatabaseDriver}
\title{buildGODatabaseDriver}
\usage{
buildGODatabaseDriver(goaDir, gobasic, dir = NULL, verbose = FALSE)
}
\arguments{
\item{goaDir}{character string path name to directory containing downloaded goa .gaf files}

\item{gobasic}{character string path name to downloaded go-basic.obo}

\item{dir}{character string path name to directory to hold species database subdirectories}

\item{verbose}{Boolean if TRUE print out some diagnostic info}
}
\value{
returns GO database with columns c("HGNC","GO","RELATION","NAME","ONTOLOGY")
}
\description{
driver to build multiple GO databases for many species
}
\details{
download goa .gaf files from https://current.geneontology.org/products/pages/downloads.html
download go-basic.obo from https://geneontology.org/docs/download-ontology/

The output GOGOA3 was saved as an .RData file.
This was too large for CRAN.
It is available from https://github.com/barryzee/GO/tree/main/databases
}
\examples{
\dontrun{
# replace my path names for goa and gobasic with your own!!
# these were obtained from the download sites listed in 'details' section
goaDir<-"/Users/barryzeeberg/Downloads/gaf/"
gobasic<-"~/go-basic.obo"
buildGODatabaseDriver(goaDir,gobasic,dir="~/personal",verbose=TRUE)
}

# here is a small example that you can run
goaDir<-system.file("extdata",package="minimalistGODB")
gobasic<-system.file("extdata","go-basic.small.obo",package="minimalistGODB")
dir<-tempdir()
buildGODatabaseDriver(goaDir,gobasic,dir,verbose=TRUE)

}
