% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf-stream.R
\name{pdf_polyline}
\alias{pdf_polyline}
\title{Add a polyline to a PDF doc}
\usage{
pdf_polyline(doc, xs, ys, ..., gp = pgpar(), tf = NULL, clip = NULL)
}
\arguments{
\item{doc}{A \code{pdf_doc} object created by \code{\link{create_pdf}()}}

\item{xs, ys}{vertex coordinates}

\item{...}{further arguments to be added to \code{gp}}

\item{gp}{A named list \code{gp} object created by \code{\link{pgpar}()}}

\item{tf}{either a single transform (\code{tf_translate()}, \code{tf_scale()},
\code{tf_rotate()}), or a list of these transforms.  Default: NULL,
no local transformation applied (global transformations still apply)}

\item{clip}{either a single clip (\code{clip_rect()}, \code{clip_polygon()}),
or a list of these clips.  Default: NULL,
no local clipping applied (global clipping still applicable)}
}
\value{
\code{pdf_doc}
}
\description{
Add a polyline to a PDF doc
}
\examples{
doc <- create_pdf() |>
   pdf_polyline(xs = c(100, 200, 200), ys = c(100, 100, 200))
}
\seealso{
Other object creation functions: 
\code{\link{pdf_bezier}()},
\code{\link{pdf_circle}()},
\code{\link{pdf_image}()},
\code{\link{pdf_line}()},
\code{\link{pdf_polygon}()},
\code{\link{pdf_rect}()},
\code{\link{pdf_text}()}
}
\concept{object creation functions}
