% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnRR_wrappers.R
\name{lnRR_inter}
\alias{lnRR_inter}
\title{Interaction effect: Log Response Ratio}
\usage{
lnRR_inter(
  data,
  col_names = c("yi", "vi"),
  append = TRUE,
  Ctrl_mean,
  Ctrl_sd,
  Ctrl_n,
  A_mean,
  A_sd,
  A_n,
  B_mean,
  B_sd,
  B_n,
  AB_mean,
  AB_sd,
  AB_n
)
}
\arguments{
\item{data}{Data frame containing the variables used.}

\item{col_names}{Vector of two strings to name the output columns for the effect size and its sampling variance. Default is 'yi' and 'vi'.}

\item{append}{Logical. Append the results to \code{data}. Default is TRUE}

\item{Ctrl_mean}{Mean outcome from the Control treatment}

\item{Ctrl_sd}{Standard deviation from the control treatment}

\item{Ctrl_n}{Sample size from the control treatment}

\item{A_mean}{Mean outcome from the treatment}

\item{A_sd}{Standard deviation from the treatment}

\item{A_n}{Sample size from the treatment}

\item{B_mean}{Mean outcome from the B treatment}

\item{B_sd}{Standard deviation from the B treatment}

\item{B_n}{Sample size from the B treatment}

\item{AB_mean}{Mean outcome from the interaction AxB treatment}

\item{AB_sd}{Standard deviation from the interaction AxB treatment}

\item{AB_n}{Sample size from the interaction AxB treatment}
}
\value{
A data frame containing the effect sizes and their sampling variance.
By default, the columns are named \code{yi} (effect size) and \code{vi} (sampling variance).
If \code{append = TRUE}, the results are appended to the input \code{data}; otherwise, only the computed effect size columns are returned.
}
\description{
Computes the interaction effect between factors A and B in factorial
data.
}
\details{
See the package vignette for a detailed description of the formula.
}
\examples{
data <- data.frame(
  study_id = 1:2,
  control_mean = c(25, 28), control_sd = c(3.2, 3.8), control_n = c(15, 17),
  predation_mean = c(18, 20), predation_sd = c(2.9, 3.1), predation_n = c(16, 18),
  competition_mean = c(22, 24), competition_sd = c(3.0, 3.5), competition_n = c(14, 16),
  pred_comp_mean = c(12, 15), pred_comp_sd = c(2.1, 2.6), pred_comp_n = c(15, 17)
)

# Compute interaction effect between predation and competition
result <- lnRR_inter(
  data = data,
  Ctrl_mean = "control_mean", Ctrl_sd = "control_sd", Ctrl_n = "control_n",
  A_mean = "predation_mean", A_sd = "predation_sd", A_n = "predation_n",
  B_mean = "competition_mean", B_sd = "competition_sd", B_n = "competition_n",
  AB_mean = "pred_comp_mean", AB_sd = "pred_comp_sd", AB_n = "pred_comp_n"
)

}
\references{
Morris, W. F., Hufbauer, R. A., Agrawal, A. A., Bever, J. D., Borowicz, V. A.,
Gilbert, G. S., ... & Vázquez, D. P. (2007). Direct and interactive
effects of enemies and mutualists on plant performance: a meta‐analysis.
Ecology, 88(4), 1021-1029. https://doi.org/10.1890/06-0442
}
\author{
Facundo Decunta - fdecunta@agro.uba.ar
}
