% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descript.R
\name{descript}
\alias{descript}
\title{Descriptive Statistics}
\usage{
descript(data, ...,
         print = c("all", "default", "n", "nNA", "pNA", "nUQ", "m", "se.m",
                   "var", "sd", "min", "p.min", "p25", "med", "p75", "max", "p.max",
                   "range", "iqr", "skew", "kurt"),
         group = NULL, split = NULL, sample = FALSE, sort.var = FALSE,
         na.omit = FALSE, digits = 2, as.na = NULL, write = NULL, append = TRUE,
         check = TRUE, output = TRUE)
}
\arguments{
\item{data}{a numeric vector or data frame with numeric variables,
i.e., factors and character variables are excluded from
\code{data} before conducting the analysis.}

\item{...}{an expression indicating the variable names in \code{data},
e.g., \code{descript(dat, x1, x2, x3)}. Note that the operators
\code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{print}{a character vector indicating which statistical measures to be
printed on the console, i.e., \code{n} (number of observations),
\code{nNA} (number of missing values), \code{pNA} (percentage of
missing values), \code{nUQ} (number of unique elements after
omitting missing values), \code{m} (arithmetic mean), \code{se.m}
(standard error of the arithmetic mean), \code{var} (variance),
\code{sd} (standard deviation), \code{med} (median),\code{min} (minimum),
\code{p.min} (percentage of observations at the minimum),
\code{p25} (25th percentile, first quartile), \code{p75} (75th
percentile, third quartile), \code{max} (maximum), \code{p.max}
(percentage of observations at the maximum)\code{range} (range),
\code{iqr} (interquartile range), \code{skew} (skewness),
and \code{kurt} (excess kurtosis). The default setting is
\code{print = c("n", "nNA", "pNA", "nUQ", "m", "sd", "min", "pmin", "max", "p.max", "skew", "kurt")}.}

\item{group}{a numeric vector, character vector or factor as grouping variable.
Alternatively, a character string indicating the variable name
of the grouping variable in \code{data} can be specified.}

\item{split}{a numeric vector, character vector or factor as split variable.
Alternatively, a character string indicating the variable name
of the split variable in \code{data} can be specified.}

\item{sample}{logical: if \code{TRUE} (default), the univariate sample skewness
or kurtosis is computed, while the population skewness or kurtosis
is computed when \code{sample = FALSE}.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables when
specifying \code{group}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before
conducting the analysis (i.e., listwise deletion).}

\item{digits}{an integer value indicating the number of decimal places to be
used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis. Note that \code{as.na()} function is only applied
to \code{data}, but not to \code{group} or \code{split}.}

\item{write}{a character string naming a file for writing the output into
either a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}) or Excel file with file extension
\code{".xlsx"}  (e.g., \code{"Output.xlsx"}). If the file
name does not contain any file extension, an Excel file will
be written.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{data}}{list with the input specified in \code{data}, \code{group}, and \code{split}}
\item{\code{args}}{specification of function arguments}
\item{\code{result}}{result table}
}
\description{
This function computes summary statistics for one or more than one variable, optionally
by a grouping and/or split variable. By default, the function prints
the number of observations (\code{n}), number of missing values (\code{nNA}),
percentage of missing values (\code{\%NA}), number of unique elements after omitting
missing values (\code{nUQ}), arithmetic mean (\code{M}), standard deviation (\code{SD}),
minimum (\code{Min}), percentage of observations at the minimum (\code{\%Min}),
maximum (\code{Max}), percentage of observations at the maximum (\code{\%Max}),
skewness (\code{Skew}), and kurtosis (\code{Kurt}).
}
\details{
\describe{
\item{\strong{Floor and Ceiling Effects}}{This function computes the percentage
of observations at both the minimum and maximum to evaluate floor and ceiling
effects in continuous variables. Historically, floor or ceiling effects are
considered to be present if more than 15\% of observations are at the lowest
or highest possible score (McHorney & Tarlov, 1995; Terwee et al., 2007).
Muthen (2023, see video at 7:58) noted the rule of thumb that linear models should be
avoided when the floor or ceiling effect of the outcome variable exceeds 25\%.}
}
}
\examples{
#----------------------------------------------------------------------------
# Descriptive statistics

# Example 1a: Descriptive statistics for 'mpg', 'cyl', and 'hp'
descript(mtcars, mpg, cyl, hp)

# Alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp")])

# Example 1b: Print all available statistical measures
descript(mtcars, mpg, cyl, hp, print = "all")

# Example 1c: Print default statistical measures plus median
descript(mtcars, mpg, cyl, hp, print = c("default", "med"))

#----------------------------------------------------------------------------
# Grouping and Split Variable

# Example 2a: Grouping variable
descript(mtcars, mpg, cyl, hp, group = "vs")

# Alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp")], group = mtcars$vs)

# Another alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp", "vs")], group = "vs")

# Example 2b: Split variable
descript(mtcars, mpg, cyl, hp, split = "am")

# Alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp")], split = mtcars$am)

# Another alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp", "am")], split = "am")

# Example 2c: Grouping and split variable
descript(mtcars, mpg, cyl, hp, group = "vs", split = "am")

# Alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp")], group = mtcars$vs, split = mtcars$am)

# Another alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp", "vs", "am")], group = "vs", split = "am")

\dontrun{
#----------------------------------------------------------------------------
# Write Output

# Example 3a: Text file
descript(mtcars, write = "Descript_Text.txt")

# Example 3b: Excel file
descript(mtcars, write = "Descript_Excel.xlsx")
}
}
\references{
McHorney, C. A., & Tarlov, A. R. (1995). Individual-patient monitoring in clinical
practice: are available health status surveys adequate?.
\emph{Quality of Life Research, 4}(4), 293-307. https://doi.org/10.1007/BF01593882

Muthen, B. (2023, Feb. 28). \emph{Mplus Web Talk No. 6 - Using Mplus To Do Dynamic Structural
Equation Modeling: Segment 3, Descriptive Analyses} [Video]. YouTube. https://www.statmodel.com/Webtalk6.shtml

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology
- Using R and SPSS}. John Wiley & Sons.

Terwee, C. B., Bot, S. D., de Boer, M. R., van der Windt, D. A., Knol, D. L.,
Dekker, J., Bouter, L. M., & de Vet, H. C. (2007). Quality criteria were proposed
for measurement properties of health status questionnaires.
\emph{Journal of Clinical Epidemiology, 60}(1), 34-42.
https://doi.org/10.1016/j.jclinepi.2006.03.012
}
\seealso{
\code{\link{ci.mean}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}},
\code{\link{ci.prop}}, \code{\link{ci.prop.diff}}, \code{\link{ci.var}},
\code{\link{ci.sd}}, \code{\link{freq}}, \code{\link{crosstab}},
\code{\link{multilevel.descript}}, \code{\link{na.descript}}.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
