% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconvolve.R
\name{deconvolve}
\alias{deconvolve}
\title{Deconvolves Thermogravimetric Data}
\usage{
deconvolve(process_object, lower_temp = 120, upper_temp = 700,
  seed = 1, n_peaks = NULL, start_vec = NULL, lower_vec = NULL,
  upper_vec = NULL)
}
\arguments{
\item{process_object}{process object obtained from process function}

\item{lower_temp}{lower temperature bound to crop dataset, default to 120}

\item{upper_temp}{upper temperature bound to crop dataset, default to 700}

\item{seed}{random seed for nloptr optimiser}

\item{n_peaks}{number of curves optional specification}

\item{start_vec}{vector of starting values for nls function. Only specify this vector if
you have selected the number of curves in the n_peaks parameter.}

\item{lower_vec}{vector of lower bound values for nls. Only specify this vector if
you have selected the number of curves in the n_peaks parameter.}

\item{upper_vec}{vector of upper bound values for nls. Only specify this vector if
you have selected the number of curves in the n_peaks parameter.}
}
\value{
decon list containing amended dataframe, temperature bounds,
minpack.lm model fit, the number of curves fit, and estimated component weights
}
\description{
This function deconvolves thermogravimetric data using a Fraser-Suzuki mixture model
}
\examples{
\donttest{
data(juncus)
tmp <- process(juncus, init_mass = 18.96,
               temp = 'temp_C', mass_loss = 'mass_loss')
output <- deconvolve(tmp)
my_starting_vec <- c(height_1 = 0.003, skew_1 = -0.15, position_1 = 250, width_1 = 50,
                     height_2 = 0.006, skew_2 = -0.15, position_2 = 320, width_2 = 30,
                     height_3 = 0.001, skew_3 = -0.15, position_3 = 390, width_3 = 200)
output <- deconvolve(tmp, n_peaks = 3, start_vec = my_starting_vec)
}
}
\keyword{deconvolution}
\keyword{fraser-suzuki}
\keyword{thermogravimetry}
