% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mmVarFit.R
\name{computeELBO}
\alias{computeELBO}
\title{Compute a lower bound on the log-likelihood (ELBO)}
\usage{
computeELBO(model)
}
\arguments{
\item{model}{a \code{mixedMemModel} object created by the \code{mixedMemModel} constructor.}
}
\value{
\code{computeELBO} returns the lower bound on the log-likelihood, a real number.
}
\description{
\code{computeELBO} computes the variational lower bound on the log-likelihood, also called the ELBO, for a mixed membership model.
}
\details{
The lower bound (ELBO) is the objective function in the variational EM algorithim.
It is a function of the latent variables (\eqn{\phi} and \eqn{\delta}) and the parameters (\eqn{\alpha} and \eqn{\theta})
that be derived from Jensen's inequality:

\eqn{E_Q{\log[p(X,Z, \Lambda)]} - E_Q{\log[Q(Z, \Lambda|\phi, \delta)]} \le\log P(obs |\alpha, \theta) }
}

