% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_var.R
\name{show_var}
\alias{show_var}
\title{Show multiply imputed values for a single variable}
\usage{
show_var(data, imp_list, x, true_values = NULL)
}
\arguments{
\item{data}{The original data with missing data.}

\item{imp_list}{A list of \code{m} imputed datasets returned by the \code{mixgb} imputer.}

\item{x}{The name of a variable of interest.}

\item{true_values}{A vector of the true values (if known) of the missing values. In general, this is unknown.}
}
\value{
A data.table with \code{m} columns, each column represents the imputed values of all missing entries in the specified variable. If \code{true_values} is provided, the last column will be the true values of the missing values.
}
\description{
Show m sets of imputed values for a specified variable.
}
\examples{
# obtain m multiply datasets
library(mixgb)
imp_list <- mixgb(data = nhanes3, m = 3)

imp_head <- show_var(
  imp_list = imp_list, x = "head_circumference_cm",
  data = nhanes3
)
}
