% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc.R
\name{covariate_depth}
\alias{covariate_depth}
\title{Maximal covariate memory of a VLMC with covariates}
\usage{
covariate_depth(model)
}
\arguments{
\item{model}{a covlmc object}
}
\value{
the longest covariate memory of this model
}
\description{
This function return the longest covariate memory used by a VLMC
with covariates.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.5, 1))))
m_nocovariate <- vlmc(dts)
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 10)
covariate_depth(m_cov)
}
