% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.arff.R
\name{read.arff}
\alias{read.arff}
\title{Read an ARFF file}
\usage{
read.arff(filename, use_xml = TRUE, auto_extension = TRUE, xml_file,
  label_indices, label_names, label_amount, ...)
}
\arguments{
\item{filename}{Name of the dataset}

\item{use_xml}{Specifies whether to use an
associated XML file to identify the labels. Defaults to TRUE}

\item{auto_extension}{Specifies whether to add
the '.arff' and '.xml' extensions to the filename
where appropriate. Defaults to TRUE}

\item{xml_file}{Path to the XML file. If not
provided, the filename ending in ".xml" will be
assumed}

\item{label_indices}{Optional vector containing the indices of the attributes
that should be read as labels}

\item{label_names}{Optional vector containing the names of the attributes
that should be read as labels}

\item{label_amount}{Optional parameter indicating the number of labels in the
dataset, which will be taken from the last attributes of the dataset}

\item{...}{Extra parameters that will be passed to the parsers. Currently
only the option \code{stringsAsFactors} is available}
}
\value{
A list containing four members: \code{dataframe} containing the dataset,
 \code{labelIndices} specifying the indices of the attributes that correspond to
 labels, \code{attributes} containing name and type of each attribute and \code{name} of
 the dataset.
}
\description{
Reads a multilabel dataset from an ARFF file in Mulan or MEKA
and retrieves instances distinguishing attributes corresponding to labels
}
\examples{

library(mldr)
\dontrun{
# Read "yeast.arff" and labels from "yeast.xml"
mymld <- read.arff("yeast")
}
}
\seealso{
\code{\link{mldr_from_dataframe}}, \code{\link{mldr}}
}
