% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTorchActivation.R
\name{nn_reglu}
\alias{nn_reglu}
\title{ReGLU Module}
\usage{
nn_reglu()
}
\description{
Rectified Gated Linear Unit (ReGLU) module.
Computes the output as \eqn{\text{ReGLU}(x, g) = x \cdot \text{ReLU}(g)}
where \(x\) and \(g\) are created by splitting the input tensor in half along the last dimension.
}
\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
x = torch::torch_randn(10, 10)
reglu = nn_reglu()
reglu(x)
\dontshow{\}) # examplesIf}
}
\references{
Shazeer N (2020).
\dQuote{GLU Variants Improve Transformer.}
2002.05202, \url{https://arxiv.org/abs/2002.05202}.
}
