% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_callbacks.R
\name{mlr3tuning.asnyc_mlflow}
\alias{mlr3tuning.asnyc_mlflow}
\title{MLflow Connector Callback}
\description{
This \link[mlr3misc:Callback]{mlr3misc::Callback} logs the hyperparameter configurations and the performance of the configurations to MLflow.
}
\examples{
# example only runs if mlflow is available
if (mlr3misc::require_namespaces("mlflow", quietly = TRUE)) {
clbk("mlr3tuning.async_mlflow", tracking_uri = "http://localhost:5000")

\dontrun{
rush::rush_plan(n_workers = 4)

learner = lrn("classif.rpart",
  minsplit = to_tune(2, 128),
  cp = to_tune(1e-04, 1e-1))

instance = TuningInstanceAsyncSingleCrit$new(
  task = tsk("pima"),
  learner = learner,
  resampling = rsmp("cv", folds = 3),
  measure = msr("classif.ce"),
  terminator = trm("evals", n_evals = 20),
  store_benchmark_result = FALSE,
  callbacks = clbk("mlr3tuning.rush_mlflow", tracking_uri = "http://localhost:8080")
)

tuner = tnr("random_search_v2")
tuner$optimize(instance)
}}
}
