% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dmr_region.R
\name{plot_dmr_region}
\alias{plot_dmr_region}
\title{Plot mean methylation profiles for a selected DMR}
\usage{
plot_dmr_region(
  dmr_table,
  cancer_data,
  normal_data,
  dmr_index = 1,
  main = NULL,
  ...
)
}
\arguments{
\item{dmr_table}{A data frame of DMRs, typically the result of
\code{mmcmcBayes()} with \code{return_mcmc = FALSE}.}

\item{cancer_data}{A data frame of cancer group methylation data in the
format used by \code{mmcmcBayes()} (rows = CpGs, columns = metadata +
M-values for cancer samples).}

\item{normal_data}{A data frame of normal-group methylation data in the same
format and CpG ordering as \code{cancer_data}.}

\item{dmr_index}{Integer index of the DMR to plot (row index in
\code{dmr_table}). Defaults to 1.}

\item{main}{Optional main title for the plot. If \code{NULL}, a title is
constructed from the region information.}

\item{...}{Additional arguments passed to \code{plot()}.}
}
\value{
The function is called for its side effect of creating a plot. It returns
(invisibly) a list containing the CpG IDs in the region and the mean
profiles for cancer and normal groups.
}
\description{
Visualize a single DMR detected by \code{mmcmcBayes()} by plotting the mean
M-values across CpG sites in the region for the cancer and normal groups.
}
\details{
This function takes the DMR table returned by \code{mmcmcBayes()} together 
with the original \code{cancer_data} and \code{normal_data} matrices used 
in the analysis. It selects one DMR by index and computes, for each CpG site 
in the region, the mean M-value across cancer samples and across normal samples. 
These two mean profiles are then plotted against the CpG index within the region.

The input data frames \code{cancer_data} and \code{normal_data} are expected
to have the same CpG sites in the same order, with at least the columns
\code{CpG_ID} and \code{Chromosome}, followed by one column per sample
containing M-values. Sample columns are identified automatically as those
whose names start with \code{"M_sample"}.

CpG sites whose mean M-value is \code{NA} or non finite in either group are
removed prior to plotting. The x axis index therefore refers to the filtered
CpG positions within the selected region.
}
\examples{
\donttest{
data(cancer_demo)
data(normal_demo)

set.seed(2021)
mcmc <- list(nburn = 1000, niter = 2000, thin = 1)

dmr_res <- mmcmcBayes(
  cancer_demo, normal_demo,
  stage         = 1,
  max_stages    = 2,
  num_splits    = 5,
  mcmc          = mcmc,
  priors_cancer = NULL,
  priors_normal = NULL,
  bf_thresholds = c(0.5, 0.8, 1.05)
)

plot_dmr_region(dmr_res, cancer_demo, normal_demo, dmr_index = 1)
}

}
