% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authModule.R
\name{authServer}
\alias{authServer}
\title{Server function for Authentication Shiny Module}
\usage{
authServer(id, postgres_module, user_table = "users")
}
\arguments{
\item{id}{A character string that matches the ID used in \code{authUI()}}

\item{postgres_module}{A postgresModule instance to handle database operations}

\item{user_table}{A character string specifying the name of the users table}
}
\value{
A list containing authentication status and user information
}
\description{
This function sets up the server-side logic for the Authentication module,
handling user authentication, signup, and guest access.
}
\examples{
server <- function(input, output, session) {
  postgres <- postgresServer("postgres_module", ...)
  auth <- authServer("auth_module", postgres, "users")
}
}
