% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_Community.R
\name{sim_poisson_coords}
\alias{sim_poisson_coords}
\title{Simulate random spatial coordinates}
\usage{
sim_poisson_coords(abund_vec, xrange = c(0, 1), yrange = c(0, 1), seed = NULL)
}
\arguments{
\item{abund_vec}{Species abundance vector (integer)}

\item{xrange}{Extent of the community in x-direction (numeric vector of length 2)}

\item{yrange}{Extent of the community in y-direction (numeric vector of length 2)}

\item{seed}{Integer. Any integer passed to \code{set.seed} for reproducibility.}
}
\value{
A community object as defined by \code{\link{community}}.
}
\description{
Add random spatial positions to a species abundance distribution.
}
\examples{
abund <- sim_sad(s_pool = 100, n_sim = 1000)
sim_com1 <- sim_poisson_coords(abund)
plot(sim_com1)
summary(sim_com1)

}
\author{
Felix May
}
