% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declaratives.R
\name{refer}
\alias{refer}
\title{Copy Bindings from a Module to Another}
\usage{
refer(..., include = c(), exclude = c(), prefix = "", sep = ".")
}
\arguments{
\item{...}{names of modules; dot-dot-dot}

\item{include}{names to include; character}

\item{exclude}{names to excludde; character}

\item{prefix}{prefix to names; character}

\item{sep}{separator between prefix and names; character}
}
\value{
\code{NULL}; invisible
}
\description{
Can only be used inside a module expression.
Makes reference to objects from one module, with specified filters.
}
\examples{

mod_a <- mod::ule(number <- 1)
mod_b <- mod::ule(number <- 2)

mod_c <- mod::ule({
    mod:::refer(mod_a, mod_b, prefix = .)
    # It is suggested to omit mod::: when using
    number <- mod_a.number + mod_b.number
})

mod_c$number

}
