% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{pool_contrasts}
\alias{pool_contrasts}
\title{Pool contrasts and comparisons from \code{estimate_contrasts()}}
\usage{
pool_contrasts(x, ...)
}
\arguments{
\item{x}{A list of \code{estimate_contrasts} objects, as returned by
\code{estimate_contrasts()}.}

\item{...}{Currently not used.}
}
\value{
A data frame with pooled comparisons or contrasts of predictions.
}
\description{
This function "pools" (i.e. combines) multiple \code{estimate_contrasts} objects,
returned by \code{\link[=estimate_contrasts]{estimate_contrasts()}}, in a similar fashion as \code{\link[mice:pool]{mice::pool()}}.
}
\details{
Averaging of parameters follows Rubin's rules (\emph{Rubin, 1987, p. 76}).
}
\examples{
\dontshow{if (require("mice")) withAutoprint(\{ # examplesIf}
data("nhanes2", package = "mice")
imp <- mice::mice(nhanes2, printFlag = FALSE)
comparisons <- lapply(1:5, function(i) {
  m <- lm(bmi ~ age + hyp + chl, data = mice::complete(imp, action = i))
  estimate_contrasts(m, "age")
})
pool_contrasts(comparisons)
\dontshow{\}) # examplesIf}
}
\references{
Rubin, D.B. (1987). Multiple Imputation for Nonresponse in Surveys. New York:
John Wiley and Sons.
}
