% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geography.R
\name{mn_boundaries}
\alias{mn_boundaries}
\title{Mongolia administrative boundaries (sf)}
\usage{
mn_boundaries(level = c("ADM0", "ADM1", "ADM2"))
}
\arguments{
\item{level}{One of "ADM0", "ADM1", "ADM2".}
}
\value{
An \code{sf} object with polygons for the requested level.
}
\description{
Downloads Mongolia boundaries for ADM0/ADM1/ADM2 from the GeoBoundaries API
and returns an \code{sf} object. Results can be cached by the caller as needed.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
# Get aimag (province) boundaries
aimags <- mn_boundaries("ADM1")
head(aimags)
\dontshow{\}) # examplesIf}
}
