% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiz-xml.R
\name{moodlequiz}
\alias{moodlequiz}
\title{R Markdown format for Moodle XML quizzes}
\usage{
moodlequiz(
  replicates = 1L,
  self_contained = TRUE,
  extra_dependencies = NULL,
  theme = NULL,
  includes = NULL,
  lib_dir = NULL,
  md_extensions = NULL,
  pandoc_args = NULL,
  ...
)
}
\arguments{
\item{replicates}{The number of times the questions are rendered, useful for
producing multiple versions of the same quiz with different random samples.
To keep identify replicates of questions for random importation into Moodle
we recommend organising the materials into categories using top level
headers.}

\item{self_contained}{Produce a standalone HTML file with no external
dependencies, using data: URIs to incorporate the contents of linked
scripts, stylesheets, images, and videos. Note that even for self contained
documents MathJax is still loaded externally (this is necessary because of
its size).}

\item{extra_dependencies}{Extra dependencies as a list of the
\code{html_dependency} class objects typically generated by
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}.}

\item{theme}{One of the following:
\itemize{
\item A \code{\link[bslib:bs_theme]{bslib::bs_theme()}} object (or a list of \code{\link[bslib:bs_theme]{bslib::bs_theme()}} argument values)
\itemize{
\item Use this option for custom themes using Bootstrap 4 or 3.
\item In this case, any \code{.scss}/\code{.sass} files provided to the \code{css}
parameter may utilize the \code{theme}'s underlying Sass utilities
(e.g., variables, mixins, etc).
}
\item \code{NULL} for no theme (i.e., no \code{\link[rmarkdown:html_dependency_bootstrap]{html_dependency_bootstrap()}}).
\item A character string specifying a \href{https://bootswatch.com/3/}{Bootswatch 3}
theme name (for backwards-compatibility).
}}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link[rmarkdown]{includes}} function).}

\item{lib_dir}{Directory to copy dependent HTML libraries (e.g. jquery,
bootstrap, etc.) into. By default this will be the name of the document with
\verb{_files} appended to it.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition of R Markdown. See the \code{\link[rmarkdown]{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{...}{Additional function arguments to pass to the base R Markdown HTML
output formatter \code{\link[rmarkdown]{html_document_base}}}
}
\value{
R Markdown output format to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}
}
\description{
Provides an alternative interface to working with the exams package for
producing Moodle questions any type.
}
