% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mop_distance.R
\name{mop_distance}
\alias{mop_distance}
\title{MOP distance calculation}
\usage{
mop_distance(m_matrix, g_matrix, distance = "euclidean", percentage = 1,
             comp_each = 2000, tol = NULL, parallel = FALSE, n_cores = NULL,
             progress_bar = TRUE)
}
\arguments{
\item{m_matrix}{matrix of variables representing the set of conditions to be
used as reference. Each column represents a variable.}

\item{g_matrix}{matrix of variables representing the set of conditions to be
compared against the reference conditions (where distances are to be
calculated). Each column represents a variable. Variable names must match
those in \code{m_matrix}.}

\item{distance}{\code{character}, one of two options: "euclidean" or "mahalanobis".}

\item{percentage}{\code{numeric}, percentage of points of m (the closest ones)
used to derive mean environmental distances to each g point.}

\item{comp_each}{\code{numeric}, number of points of the g matrix to be used for
distance calculations at a time (default = 2000). Increasing this number
requires more RAM.}

\item{tol}{tolerance to detect linear dependencies when calculating
Mahalanobis distances. The default, NULL, uses \code{.Machine$double.eps}.}

\item{parallel}{\code{logical}, if TRUE, calculations will be performed in parallel
using \code{n_cores} of the computer. Using this option will speed up the
analysis  but will demand more RAM.}

\item{n_cores}{\code{numeric}, number of cores to be used in parallel processing.
Uses current host CPU cores - 1 by default.}

\item{progress_bar}{\code{logical}, whether to show a progress bar for
calculations. Valid when calculations are not run in parallel.}
}
\value{
A numeric vector with values of distances calculated according to
parameters used.
}
\description{
Calculates distances from each of the points of interest in \code{g_matrix}
to a defined percentage of the reference conditions in \code{m_matrix}.
}
\examples{
# data
data("reference_matrix", package = "mop")
data("matrix_of_interest", package = "mop")

# analysis
mop_dist <- mop_distance(m_matrix = reference_matrix,
                         g_matrix = matrix_of_interest)
}
