% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-Data.R, R/plot-DataBinary.R,
%   R/plot-DataContinuous.R, R/plot-DataCount.R
\name{PlotData}
\alias{PlotData}
\alias{plot.BinaryData}
\alias{plot.ContinuousData}
\alias{plot.CountData}
\title{Plotting method for \code{BinaryData}, \code{CountData} or
\code{ContinuousData}.}
\usage{
\method{plot}{BinaryData}(
  x,
  xlab = "Time",
  ylab = "Sum of Non-Failure",
  main = NULL,
  concentration = NULL,
  pool.replicate = FALSE,
  addlegend = FALSE,
  ...
)

\method{plot}{ContinuousData}(
  x,
  xlab = "Time",
  ylab = "Measure",
  main = NULL,
  concentration = NULL,
  addlegend = FALSE,
  ...
)

\method{plot}{CountData}(
  x,
  xlab = "Time",
  ylab = "Cumulated Response",
  main = NULL,
  concentration = NULL,
  pool.replicate = FALSE,
  addlegend = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{BinaryData}, \code{CountData} or
\code{ContinuousData}}

\item{xlab}{a label for the \eqn{X}-axis, by default \code{Time}}

\item{ylab}{a label for the \eqn{Y}-axis, by default
\code{Sum of Non-Failure} for  \code{BinaryData},
\code{Cumulated Response} for \code{CountData}, and
\code{Measure} for \code{ContinuousData}.}

\item{main}{title for the plot}

\item{concentration}{a numeric value corresponding to some concentration(s) in
\code{data}. If \code{concentration = NULL}, draws a plot for each concentration}

\item{pool.replicate}{if \code{TRUE}, the datapoints of each replicate are
summed for a same concentration}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
a plot of class \code{ggplot}
}
\description{
This is the generic \code{plot} S3 method for the \code{BinaryData},
\code{CountData} and \code{ContinuousData} classes.
\itemize{
\item \code{BinaryData}: It plots the sum of non-failure (survivor, mobile)
individuals as a function of time.
\item \code{CountData}: It plots the cumulated number of offspring as a
function of time.
\item \code{Continuous}: It plots the continuous data as a
function of time by concentration panels.
}
}
\keyword{plot}
