test_that("SurvData", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    data("propiconazole")
    cPRZ = survData(propiconazole)
    
    expect_no_error({
        plot(cPRZ)
        plot(cPRZ, one_plot = TRUE)
    })
    
    data("propiconazole_pulse_exposure")
    vPRZ = survData(propiconazole_pulse_exposure)
    
    expect_no_error({
        plot(vPRZ)
        plot(vPRZ, add_legend = TRUE)
        plot(vPRZ, one_plot = TRUE)
    })
})

test_that("SurvFit", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    cPRZ_ITfit <- readRDS(test_path("fixtures", "cPRZ_ITfit.rds"))
    cPRZ_SDfit <- readRDS(test_path("fixtures", "cPRZ_SDfit.rds"))
    vPRZ_ITfit <- readRDS(test_path("fixtures", "vPRZ_ITfit.rds"))
    vPRZ_SDfit <- readRDS(test_path("fixtures", "vPRZ_SDfit.rds"))
    
    expect_no_error({
        plot(cPRZ_ITfit)
        plot(cPRZ_SDfit)
        plot(vPRZ_ITfit)
        plot(vPRZ_SDfit)
    })
})

test_that("SurvPredict", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    cPRZ_ITpred <- readRDS(test_path("fixtures", "cPRZ_ITpred.rds"))
    cPRZ_SDpred <- readRDS(test_path("fixtures", "cPRZ_SDpred.rds"))
    cPRZ_ITpred100 <- readRDS(test_path("fixtures", "cPRZ_ITpred100.rds"))
    cPRZ_SDpred100 <- readRDS(test_path("fixtures", "cPRZ_SDpred100.rds"))
    
    expect_no_error({
        plot(cPRZ_SDpred)
        plot(cPRZ_ITpred)
        plot(cPRZ_SDpred100)
        plot(cPRZ_ITpred100)
    })
    
    vPRZ_ITpred <- readRDS(test_path("fixtures", "vPRZ_ITpred.rds"))
    vPRZ_SDpred <- readRDS(test_path("fixtures", "vPRZ_SDpred.rds"))
    vPRZ_ITpred100 <- readRDS(test_path("fixtures", "vPRZ_ITpred100.rds"))
    vPRZ_SDpred100 <- readRDS(test_path("fixtures", "vPRZ_SDpred100.rds"))
    
    expect_no_error({
        plot(vPRZ_ITpred)
        plot(vPRZ_SDpred)
        plot(vPRZ_ITpred100)
        plot(vPRZ_SDpred100)
    })
    
})

test_that("PriorPosterior", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    cPRZ_ITfit <- readRDS(test_path("fixtures", "cPRZ_ITfit.rds"))
    cPRZ_SDfit <- readRDS(test_path("fixtures", "cPRZ_SDfit.rds"))
    cPRZ_ITpp <- priorPosterior(cPRZ_ITfit)
    cPRZ_SDpp <- priorPosterior(cPRZ_SDfit)

    expect_no_error({
        plot(cPRZ_ITpp)
        plot(cPRZ_SDpp)
    })
    
    vPRZ_ITfit <- readRDS(test_path("fixtures", "vPRZ_ITfit.rds"))
    vPRZ_SDfit <- readRDS(test_path("fixtures", "vPRZ_SDfit.rds"))
    vPRZ_ITpp <- priorPosterior(vPRZ_ITfit)
    vPRZ_SDpp <- priorPosterior(vPRZ_SDfit)
    
    expect_no_error({
        plot(vPRZ_ITpp)
        plot(vPRZ_SDpp)
    })
    
})