% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{events}
\alias{events}
\title{Sample residence events}
\format{
A data frame with 11 487 rows (events) and 5 variables.
}
\usage{
data(events)
}
\description{
Events generated from the sample detection file provided. Events were generated
using the residences() function in mort.
}
\details{
The detection data were subset from a real acoustic telemetry dataset of Arctic
Char near Kugluktuk, Nunavut. The data were from a project that was a
collaboration between the Kugluktuk Hunters and Trappers Organization, the
University of Waterloo, and Fisheries and Oceans Canada. The data are valuable
to the community of Kugluktuk, and are also sensitive due to their pertinence
to the local fishery for Arctic Char. For this reason, the detections have been
given generic station names and fish IDs so locations and sample information
is anonymous. The year has also been changed, but otherwise, the detections are
real, and therefore have all the challenges and intricacies of biological
data.

The variables are as follows:

\itemize{
\item ResidenceStart. The start time of the residence events, in POSIXct.
\item Station.Name. Name of the receiver location.
\item ID. Unique ID of the fish.
\item ResidenceEnd. The end time of the residence events, in POSIXct.
\item ResidenceLength.days. The duration of the residence events. The units are
days, as indicated by the variable name (which is automatically generated
by mort::residences())
}
}
\keyword{datasets}
