% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rcens}
\alias{rcens}
\title{Generate Censored Samples (Type I or Type II)}
\usage{
rcens(n, r = NULL, dist, type = c("I", "II"), cens.time = NULL, ...)
}
\arguments{
\item{n}{total number of items in the sample}

\item{r}{number of uncensored observations (only for Type II censoring).}

\item{dist}{a character string specifying the name of the distribution
(e.g., \code{"norm"} for the normal distribution, \code{"exp"} for the exponential distribution).}

\item{type}{type of censoring: \code{"I"} for Type I (time-based) or \code{"II"} for Type II (failure-based).}

\item{cens.time}{censoring time for Type I censoring.}

\item{...}{further arguments to be passed to \code{dist}.}
}
\value{
A numeric vector of censored samples.
}
\description{
This function generates censored samples from a specified distribution, using
Type I (time-based) or Type II (failure-based) censoring schemes.
}
\details{
This function implements two types of censoring schemes:
\enumerate{
  \item \strong{Type I censoring:} Observations are censored if they exceed a specified \code{cens.time}.
  The function returns all observations less than \code{cens.time}.
  \item \strong{Type II censoring:} The smallest \code{r} observations are returned, simulating
  a situation where the experiment stops after \code{r} failures.
}
}
\examples{
# Type I censoring: Exponential distribution with rate = 1, censored at time 2
rcens(n = 10, dist = "exp", type = "I", cens.time = 2, rate = 1)

# Type II censoring: Normal distribution, smallest 5 values
rcens(n = 10, r = 5, dist = "norm", type = "II", mean = 0, sd = 1)

}
\seealso{
\code{\link{rpcens2}}
}
