% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_motifs.R
\name{simulate_baseline}
\alias{simulate_baseline}
\title{Simulate a baseline baseline model}
\usage{
simulate_baseline(
  net,
  motifs,
  n = 10,
  lvl_attr = "sesType",
  assume_sparse = TRUE,
  model = "erdos_renyi",
  level = -1,
  ergm_model = NULL,
  directed = NULL
)
}
\arguments{
\item{net}{network object}

\item{motifs}{list of motif identifier strings}

\item{n}{number of random graphs}

\item{lvl_attr}{character string specifying the attribute name where level
information is stored in \code{net}.}

\item{assume_sparse}{whether the random graphs shall be assumed to be sparse.
used to find ideal counting function. defaults to TRUE.}

\item{model}{baseline model to be used. Options are 'erdos_renyi',
'fixed_densities', 'actors_choice', 'ergm' and 'partial_ergm'. See
\code{vignette("random_baselines")} for more details. Defaults to
'erdos_renyi'.}

\item{level}{lvl_attr of the variable level for the Actor's Choice model and
for partial ERGM}

\item{ergm_model}{ergm model as for example fitted by calling
\code{ergm::ergm()}. Used when model is set to 'ergm' or 'partial_ergm' to
sample random networks.}

\item{directed}{whether the graph shall be treated as a directed graph. Per
default (\code{NULL}), this is determined automatically using the structure
of the provided network object}
}
\value{
data frame with one column for each motif identifier string and one
  row for every computed random graph
}
\description{
A baseline distribution of motif counts from a specified number of networks
using a specified baseline model is computed. Options for the baseline model are
- Erdős–Rényi
- Actor's choice
- Fixed density
- Providing an ERGM fit for the whole network
- Providing a partial ERGM fit (for only one level)
}
\details{
Note that when using the Actor's Choice model this function does not choose
the variable level automatically. Use the \code{level} parameter to provide a
valid level.

When using (partial) ERGM the parameter \code{net} is not used. Random
networks are sampled in R using the \code{ergm_model} parameter.
}
\examples{
\dontrun{
simulate_baseline(ml_net, list("1,2[I.C]"), n = 10, directed = FALSE)
}
}
