% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_main.R
\name{md_plot_preview}
\alias{md_plot_preview}
\title{Preview plot for movedesign workflow outputs (single replicate)}
\usage{
md_plot_preview(obj, error_threshold = 0.05, pal = c("#007d80", "#A12C3B"))
}
\arguments{
\item{obj}{An object of class \code{movedesign_preprocess}
(output of \code{\link[=md_run]{md_run()}}).}

\item{error_threshold}{Numeric. Error threshold (e.g. \code{0.05} for 5\%)
to display as a reference in the plot.}

\item{pal}{Character vector of two colors for within/outside threshold
(default: c("#007d80", "#A12C3B")).}
}
\value{
A ggplot object displaying relative error by population sample size,
with point estimate and confidence intervals for mean estimates,
and horizontal error threshold lines.
}
\description{
Generates a quick visualization of relative error for home range or
movement speed estimation from a single replicate of a movedesign
workflow. This functions shows preliminary outputs only and should not
be used to evaluate study design.

Use the output of \code{\link[=md_run]{md_run()}} (a
\code{movedesign_preprocess} object). Users should run \code{\link[=md_replicate]{md_replicate()}} for
a full assessment.
}
\details{
For robust results and credible intervals, use \code{\link[=md_replicate]{md_replicate()}}.
}
\examples{
if (interactive()) {
  input <- md_prepare(
    data = buffalo,
    models = models,
    species = "buffalo",
    n_individuals = 5,
    dur = list(value = 1, unit = "month"),
    dti = list(value = 1, unit = "day"),
    add_individual_variation = TRUE,
    grouped = TRUE,
    set_target = "hr",
    which_meta = "mean"
  )

  output <- md_run(input)
  md_plot_preview(output, error_threshold = 0.05)
}

}
\seealso{
\code{\link[=md_run]{md_run()}}, \code{\link[=md_replicate]{md_replicate()}}
}
