% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_filtered_views}
\alias{get_filtered_views}
\title{Get filtered views}
\usage{
get_filtered_views(r, data_points, n, p, filetype = "rda")
}
\arguments{
\item{r}{\code{Recording} object.}

\item{data_points}{vector of body parts e.g. 'Nose'.}

\item{n}{window size.}

\item{p}{poly order.}

\item{filetype}{type of file ('rda' as default), can be 'csv'.}
}
\value{
list of \code{FilteredView} objects.
}
\description{
Get filtered views
}
\examples{
r <- get_sample_recording()
fv_list <- get_filtered_views(r, "Nose", n = 41, p = 3)
plot(fv_list$Central_Tabla)
}
\seealso{
Other data functions: 
\code{\link{apply_filter_sgolay}()},
\code{\link{get_data_points}()},
\code{\link{get_duration_annotation_data}()},
\code{\link{get_feature_data}()},
\code{\link{get_joined_view}()},
\code{\link{get_metre_data}()},
\code{\link{get_onsets_selected_data}()},
\code{\link{get_processed_view}()},
\code{\link{get_processed_views}()},
\code{\link{get_raw_optflow_view}()},
\code{\link{get_raw_view}()},
\code{\link{get_raw_views}()},
\code{\link{get_recording}()},
\code{\link{get_sample_recording}()}
}
\concept{data functions}
