% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ID_barplot.R
\name{plot_ID_barplot}
\alias{plot_ID_barplot}
\title{Individual Barplots - Identifications}
\usage{
plot_ID_barplot(
  input_list,
  level = c("Precursor.IDs", "Peptide.IDs", "Protein.IDs", "ProteinGroup.IDs")
)
}
\arguments{
\item{input_list}{A list with data frames and respective level information.}

\item{level}{Character string. Choose between "Precursor.IDs", "Peptide.IDs", "Protein.IDs" or "ProteinGroup.IDs" for corresponding level. Default is "Precursor.IDs".}
}
\value{
This function returns a list with a barplot for each analysis.
}
\description{
Plot number of achieved identifications per analysis.
}
\details{
For each submitted individual analysis a detailed barplot is generated with information about the number of achieved identifications per run.
}
\examples{
# Load libraries
library(magrittr)
library(comprehenr)
library(tibble)

# Example data
data <- list(
 "A" = tibble::tibble(
   Analysis = c("A", "A", "A"),
   Run = c("R01", "R02", "R03"),
   Precursor.IDs = c(4800, 4799, 4809),
   Peptide.IDs = c(3194, 3200, 3185),
   Protein.IDs = c(538, 542, 538),
   ProteinGroup.IDs = c(487, 490, 486)
 ),
 "B" = tibble::tibble(
   Analysis = c("B", "B", "B"),
   Run = c("R01", "R02", "R03"),
   Precursor.IDs = c(4597, 4602, 4585),
   Peptide.IDs = c(3194, 3200, 3185),
   Protein.IDs = c(538, 542, 538),
   ProteinGroup.IDs = c(487, 490, 486)
 )
)

# Plot
plot_ID_barplot(
  input_list = data,
  level = "Precursor.IDs"
)
}
\author{
Oliver Kardell
}
