% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{dilutionCorrection}
\alias{dilutionCorrection}
\title{A function for scaling to individual dilution factors.}
\usage{
dilutionCorrection(mrbinResults, verbose = TRUE, errorsAsWarnings = FALSE)
}
\arguments{
\item{mrbinResults}{An mrbin object}

\item{verbose}{Should a summary be printed?}

\item{errorsAsWarnings}{If TRUE, errors will be turned into warnings. Should be used with care, as errors indicate undocumented changes to the data.}
}
\value{
An invisible mrbin object containing scaled NMR data.
}
\description{
This function performs sample-wise scaling of binned data to correct for dilution
through different sample volumes used, or for different sample weights. All bin
values of one sample are multiplied by the corresponding dilution factor.
}
\examples{
resetEnv()#clean up previous data from the package environment 
results<-mrbin(silent=TRUE,setDefault=TRUE,parameters=list(dimension="1D",
         binwidth1D=0.05,PQNScaling="No",PCA="No",logTrafo="No",
         NMRvendor="mrbin",
         example=TRUE,#only used for the package examples
         NMRfolders=c(system.file("extdata/1.mr1",package="mrbin"),
                      system.file("extdata/2.mr1",package="mrbin"),
                      system.file("extdata/3.mr1",package="mrbin"))),
         metadata=list(dilutionFactors=c(.75,1,.5)))
results<-dilutionCorrection(results)
}
