# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Create a n-by-n discrete cosine transform matrix.
#'
#' The discrete cosine transform (DCT) matrix for a given dimension n is
#' calculated.
#'
#' The function can be used for 1D- or 2D-DCT transforms of data.
#' \itemize{
#' \item \strong{1D:} Let \code{Q} be a m-by-n matrix with some data. \code{D} is a
#' m-by-m DCT matrix created by \code{dctMatrix(m)}. Then \code{D \%*\% Q} returns the
#' discrete cosine transform of the columns of Q. \code{t(D) \%*\% Q} returns the
#' inverse DCT of the columns of Q. As D is orthogonal, \code{solve(D) = t(D)}.
#' \item \strong{2D:} Let \code{Q} be a m-by-n matrix with some data. \code{D_m} is a
#' m-by-m DCT matrix created by \code{dctMatrix(m)}, \code{D_n} a n-by-n DCT matrix
#' created by \code{dctMatrix(n)}. \code{D_m \%*\% Q \%*\% t(D_n)} computes the 2D-DCT
#' of Q. The inverse 2D-DCT of Q can be computed via \cr \code{t(D_mm) \%*\% DCT_Q \%*\% D_n}.
#' D_m transforms along columns, D_n along rows. Since D is orthogonal, \code{solve(D) = t(D)}.
#' }
#' It can be faster to use \code{dctMatrix} than using a direct transformation,
#' especially when calculating several DCT's.
#'
#' @param n Dimension for the DCT matrix.
#' @return The n-by-n DCT matrix.
#' @examples
#' D <- dctMatrix(5)
dctMatrix <- function(n) {
    .Call(`_mrbsizeR_dctMatrix`, n)
}

for_eigenLaplace <- function(mu, lambda, mm, nn) {
    .Call(`_mrbsizeR_for_eigenLaplace`, mu, lambda, mm, nn)
}

initLambdaMat <- function(nGrid, N, lambda, fac, D) {
    .Call(`_mrbsizeR_initLambdaMat`, nGrid, N, lambda, fac, D)
}

min2Lambda <- function(nGrid, LambdaMat, lambda1, minimum) {
    .Call(`_mrbsizeR_min2Lambda`, nGrid, LambdaMat, lambda1, minimum)
}

min3Lambda <- function(i, nGrid, LambdaMat, lambda1, lambda2, minimum) {
    .Call(`_mrbsizeR_min3Lambda`, i, nGrid, LambdaMat, lambda1, lambda2, minimum)
}

