% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distpdf.grad.R
\name{distpdf.grad}
\alias{distpdf.grad}
\title{Gradient of the non-normalised pdf of distances or the detection function
for the distances.}
\usage{
distpdf.grad(
  distance,
  par.index,
  ddfobj,
  standardize = FALSE,
  width,
  point,
  left = 0,
  pdf.based = TRUE
)
}
\arguments{
\item{distance}{vector of distances}

\item{par.index}{the index of the parameter of interest}

\item{ddfobj}{the ddf object}

\item{standardize}{whether the function should return the gradient of the
standardized detection function g(x)/g(0) (TRUE), or simply of g(0) (FALSE). 
Currently only implemented for standardize = FALSE.}

\item{width}{the truncation width}

\item{point}{are the data from point transects (TRUE) or line transects 
(FALSE).}

\item{left}{the left truncation (default 0)}

\item{pdf.based}{is it the gradient of the non-normalised pdf (TRUE) or 
the detection function (FALSE)? Default is TRUE.}
}
\value{
the gradient of the non-normalised pdf or detection w.r.t. to 
the parameter with parameter index \code{par.index}.
}
\description{
This function has been updated to match distpdf closely, so
that it has the same flexibility. Effectively, it gives the gradient of 
distpdf or detfct, whichever one is specified.
}
\details{
Various functions used to specify key and adjustment functions for
gradients of detection functions.

So far, only developed for the half-normal, hazard-rate and uniform key
functions in combination with cosine, simple polynomial and Hermite 
polynomial adjustments. It is only called by the gradient-based solver
and should not be called by the general user.

\code{distpdf.grad} will call either a half-normal, hazard-rate or uniform
function with adjustment terms to fit the data better, returning the 
gradient of detection at that distance w.r.t. the parameters. The adjustments 
are either cosine, Hermite or simple polynomial.
}
\author{
Felix Petersma
}
