% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histgroups_iarc.R
\name{histgroup_iarc}
\alias{histgroup_iarc}
\title{Create variable for groups of malignant neoplasms considered to be histologically 'different' for the purpose of defining multiple tumors, ICD-O-3}
\usage{
histgroup_iarc(df, hist_var, new_var_hist = t_histgroupiarc, version = "3.1")
}
\arguments{
\item{df}{dataframe in long or wide format}

\item{hist_var}{variable in df that contains first 4 digits of tumor histology (without behavior)}

\item{new_var_hist}{Name of the newly calculated variable for histology groups. Default is t_histgroupiarc.}

\item{version}{Version of ICD-O-3 classification used.  Can be either "3.0" for 2000 publication, "3.1" for 2013 first revision or "3.2" for 2019 second revision.
Default is \code{version = "3.1"} for ICD-O-3 revision 1, released 2013.}
}
\value{
df
}
\description{
Create variable for groups of malignant neoplasms considered to be histologically 'different' for the purpose of defining multiple tumors, ICD-O-3
}
\examples{
#load sample data
data("us_second_cancer")

us_second_cancer \%>\% 
   msSPChelpR::histgroup_iarc(., hist_var = t_hist) \%>\%
   dplyr::select(fake_id, t_hist, t_histgroupiarc) 
                
}
