% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_settings.R
\name{chart_settings}
\alias{chart_settings}
\alias{chart_settings.ms_barchart}
\alias{chart_settings.ms_linechart}
\alias{chart_settings.ms_areachart}
\alias{chart_settings.ms_scatterchart}
\title{set chart options}
\usage{
chart_settings(x, ...)

\method{chart_settings}{ms_barchart}(x, vary_colors, gap_width, dir, grouping, overlap, table, ...)

\method{chart_settings}{ms_linechart}(x, vary_colors, style = "lineMarker", table, ...)

\method{chart_settings}{ms_areachart}(
  x,
  vary_colors = FALSE,
  grouping = "standard",
  table = FALSE,
  ...
)

\method{chart_settings}{ms_scatterchart}(x, vary_colors = FALSE, style = "marker", ...)
}
\arguments{
\item{x}{an \code{ms_chart} object.}

\item{...}{unused parameter}

\item{vary_colors}{if \code{TRUE} the data points in the single series are displayed the same color.}

\item{gap_width}{A gap appears between the bar or clustered bars for each category on a bar chart.
The default width for this gap is 150 percent of the bar width. It can be set
between 0 and 500 percent of the bar width.}

\item{dir}{the direction of the bars in the chart, value must one of "horizontal" or "vertical".}

\item{grouping}{grouping for a barchart, a linechart or an area chart. must be one of "percentStacked", "clustered", "standard" or "stacked".}

\item{overlap}{In a bar chart having two or more series, the bars for each
category are clustered together. By default, these bars are directly
adjacent to each other. The bars can be made to overlap each other or
have a space between them using the overlap property. Its values range
between -100 and 100, representing the percentage of the bar width by
which to overlap adjacent bars. A setting of -100 creates a gap of a
full bar width and a setting of 100 causes all the bars in a category
to be superimposed. The default value is 0.}

\item{table}{if \code{TRUE} set a table below the barchart.}

\item{style}{Style for the linechart or scatterchart type of markers. One
of 'none', 'line', 'lineMarker', 'marker', 'smooth', 'smoothMarker'.}
}
\description{
Set chart properties.
}
\section{Methods (by class)}{
\itemize{
\item \code{chart_settings(ms_barchart)}: barchart settings

\item \code{chart_settings(ms_linechart)}: linechart settings

\item \code{chart_settings(ms_areachart)}: linechart settings

\item \code{chart_settings(ms_scatterchart)}: linechart settings

}}
\section{Illustrations}{


\if{html}{\figure{fig_chart_settings_1.png}{options: width="500"}}

\if{html}{\figure{fig_chart_settings_2.png}{options: width="500"}}

\if{html}{\figure{fig_chart_settings_3.png}{options: width="500"}}
}

\examples{
library(mschart)
library(officer)

chart_01 <- ms_barchart(
  data = browser_data, x = "browser",
  y = "value", group = "serie"
)
chart_01 <- chart_theme(chart_01,
  grid_major_line_x = fp_border(width = 0),
  grid_minor_line_x = fp_border(width = 0)
)

chart_02 <- chart_settings(
  x = chart_01,
  grouping = "stacked", overlap = 100
)


chart_03 <- ms_areachart(
  data = browser_ts, x = "date",
  y = "freq", group = "browser"
)
chart_03 <- chart_settings(chart_03,
  grouping = "percentStacked"
)
}
\seealso{
\code{\link[=ms_barchart]{ms_barchart()}}, \code{\link[=ms_areachart]{ms_areachart()}}, \code{\link[=ms_scatterchart]{ms_scatterchart()}}, \code{\link[=ms_linechart]{ms_linechart()}}
}
