% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sde.valid.R
\name{sde.valid}
\alias{sde.valid}
\alias{sde.valid.data}
\alias{sde.valid.params}
\title{SDE data and parameter validators.}
\usage{
sde.valid.data(model, x, theta)

sde.valid.params(model, theta)
}
\arguments{
\item{model}{An \code{sde.model} object.}

\item{x}{A length-\code{ndims} vector or \code{ndims}-column matrix of SDE data.}

\item{theta}{A length-\code{nparams} vector or \code{nparams}-column of SDE parameter values.}
}
\value{
A logical scalar or vector indicating whether the given data/parameter pair is valid.
}
\description{
Checks whether input SDE data and parameters are valid.
}
\examples{
# Heston's model
# valid data is: Z > 0
# valid parameters are: gamma, sigma > 0, |rho| < 1, beta > .5 * sigma^2
hmod <- sde.examples("hest") # load model

theta <- c(alpha = 0.1, gamma = 1, beta = 0.8, sigma = 0.6, rho = -0.8)

# valid data
x0 <- c(X = log(1000), Z = 0.1)
sde.valid.data(model = hmod, x = x0, theta = theta)

# invalid data
x0 <- c(X = log(1000), Z = -0.1)
sde.valid.data(model = hmod, x = x0, theta = theta)

# valid parameters
theta <- c(alpha = 0.1, gamma = 1, beta = 0.8, sigma = 0.6, rho = -0.8)
sde.valid.params(model = hmod, theta = theta)

# invalid parameters
theta <- c(alpha = 0.1, gamma = -4, beta = 0.8, sigma = 0.6, rho = -0.8)
sde.valid.params(model = hmod, theta = theta)
}
