% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msltrend.R
\name{summary}
\alias{summary}
\title{Summary outputs of decomposed time series.}
\usage{
summary(object)
}
\arguments{
\item{object}{of class \dQuote{msl.trend} (see \code{\link{msl.trend}}) or
\dQuote{msl.forecast} (see \code{\link{msl.forecast}}).}
}
\description{
Summary outputs of decomposed time series.
}
\details{
This routine provides a screen summary of the respective outputs
from a \code{\link{msl.trend}} or \code{\link{msl.forecast}} object. The
summary produced is identical to str( ) for an object of class
\dQuote{msl.trend} (see \code{\link{msl.trend}}) or \dQuote{msl.forecast}
(see \code{\link{msl.forecast}}).
}
\examples{
# -------------------------------------------------------------------------
# Isolate trend from Baltimore record, filling gaps with spline interpolation,
# 500 iterations and adding 1000 mm of slr to 2100. Use raw 'Balt.csv' data file.
# Note: ordinarily user would call 'File.csv' direct from working directory
# using the following sample code:
# s <- msl.trend('Balt.csv', fillgaps = 3, iter = 500, 'BALTIMORE, USA')
# t <- msl.forecast(s, slr = 1000)
# -------------------------------------------------------------------------

data(s) # msl.trend object from above-mentioned example
data(t) # msl.forecast object from above-mentioned example
summary(s) # summary for object of class 'msl.trend' object
summary(t) # summary for object of class 'msl.forecast' object

}
\seealso{
\code{\link{msl.trend}}, \code{\link{msl.forecast}},
\code{\link{Balt}}, \code{\link{s}}, \code{\link{t}}.
}

