% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-mtscr.R
\name{summary.mtscr}
\alias{summary.mtscr}
\alias{summary.mtscr_list}
\title{Fit measures for mtscr model}
\usage{
\method{summary}{mtscr}(object, ...)

\method{summary}{mtscr_list}(object, ...)
}
\arguments{
\item{object}{mtscr model or a mtscr_list object.}

\item{...}{Additional arguments. Currently not used.}
}
\value{
A tibble with the following columns:
\describe{
\item{model}{The model number (only if a list of models is provided)}
\item{nobs}{Number of observations}
\item{sigma}{The square root of the estimated residual variance}
\item{logLik}{The log-likelihood of the model}
\item{AIC}{The Akaike information criterion}
\item{BIC}{The Bayesian information criterion}
\item{df.residual}{The residual degrees of freedom}
\item{emp_rel}{The empirical reliability}
\item{FDI}{The first difference of the empirical reliability}
}
}
\description{
Summarise the overall fit of a single model fitted with \code{\link[=mtscr]{mtscr()}}.
}
\section{Functions}{
\itemize{
\item \code{summary(mtscr_list)}: Get fit measures for a list of models fitted with \code{\link[=mtscr]{mtscr()}}.

}}
\examples{
data("mtscr_creativity", package = "mtscr")

mtscr_creativity <- mtscr_creativity |>
  dplyr::slice_sample(n = 500) # for performance, ignore

fit1 <- mtscr(mtscr_creativity, id, SemDis_MEAN, item, ties_method = "average")
fit3 <- mtscr(mtscr_creativity, id, SemDis_MEAN, item, top = 1:3, ties_method = "average")

summary(fit1)

summary(fit3)
}
