% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/inputs.R
\name{FormControlLabel}
\alias{FormControlLabel}
\alias{FormControlLabel.shinyInput}
\alias{updateFormControlLabel.shinyInput}
\title{FormControlLabel}
\usage{
FormControlLabel(...)

FormControlLabel.shinyInput(inputId, ..., value = defaultValue)

updateFormControlLabel.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the `session` argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/form-control-label/}
}
\details{
\itemize{
\item control \code{element} \cr Default is - A control element. For instance, it can be a Radio, a Switch or a Checkbox.
\item checked \code{bool} \cr Default is - If true, the component appears selected.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item componentsProps \verb{\{ typography?: object \}} \cr Default is The props used for each slot inside.Deprecated use the slotProps prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item disabled \code{bool} \cr Default is - If true, the control is disabled.
\item disableTypography \code{bool} \cr Default is - If true, the label is rendered as it is passed without an additional typography node.
\item inputRef \code{ref} \cr Default is - Pass a ref to the input element.
\item label \code{node} \cr Default is - A text or an element to be used in an enclosing label element.
\item labelPlacement \code{'bottom'| 'end'| 'start'| 'top'} \cr Default is 'end' The position of the label.
\item onChange \code{func} \cr Default is - Callback fired when the state is changed.Signature:function(event: React.SyntheticEvent) = voidevent The event source of the callback. You can pull out the new checked state by accessing event.target.checked (boolean).
\item required \code{bool} \cr Default is - If true, the label will indicate that the input is required.
\item slotProps \verb{\{ typography?: func| object \}} \cr Default is The props used for each slot inside.
\item slots \verb{\{ typography?: elementType \}} \cr Default is The components used for each slot inside.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item value \code{any} \cr Default is - The value of the component.
}
}
