% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{aflw}
\alias{aflw}
\title{AFLW player statistics}
\format{
A dataset with 381 rows and 35 columns
}
\description{
This is data from the 2021 Women's Australian Football League.
These are average player statistics across the season, with game statistics
provided by the \href{https://jimmyday12.github.io/fitzRoy/}{fitzRoy} package.
If you are new to the game of AFL, there is a nice
explanation on \href{https://en.wikipedia.org/wiki/Women\%27s_Australian_rules_football}{Wikipedia}.
The primary analysis is to summarise the variation using
principal component analysis, which gives information about
relationships between the statistics or skills sets common in
players. One also might be tempted to cluster the players, but
there are no obvious clusters so it could be frustrating. At
best one could partition the players into groups, while recognising
there are no absolutely distinct and separated groups.
}
\details{
\describe{
\item{id, given_name, surname, number, position, team}{player identification details}
\item{time_pct, ..., clearances}{player statistics for the match}
}
}
\examples{

require(dplyr)
data(aflw)
glimpse(aflw)
}
\keyword{datasets}
