% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DISCOsca.R
\name{DISCOsca}
\alias{DISCOsca}
\title{DISCO-SCA rotation.}
\usage{
DISCOsca(DATA, R, Jk)
}
\arguments{
\item{DATA}{A matrix, which contains the concatenated data with the same subjects from multiple blocks.
Note that each row represents a subject.}

\item{R}{Number of components (R>=2).}

\item{Jk}{A vector containing number of variables in the concatenated data matrix.}
}
\value{
\item{Trot_best}{Estimated component score matrix (i.e., T)}
\item{Prot_best}{Estimated component loading matrix (i.e., P)}
\item{comdist}{A matrix representing common distinctive components. (Rows are data blocks and columns are components.) 0 in the matrix indicating that the corresponding
component of that block is estimated to be zeros, and 1 indicates that (at least one component loading in) the corresponding component of that block is not zero.
Thus, if a column in the \code{comdist} matrix contains only 1's, then this column is a common component, otherwise distinctive component.}
\item{propExp_component}{Proportion of variance per component.}
}
\description{
A DISCO-SCA procedure for identifying common and distinctive components. The code is adapted from the orphaned RegularizedSCA package by Zhengguo Gu.
}
\examples{
\dontrun{
DATA1 <- matrix(rnorm(50), nrow=5)
DATA2 <- matrix(rnorm(100), nrow=5) 
DATA <- cbind(DATA1, DATA2)
R <- 5
Jk <- c(10, 20) 
DISCOsca(DATA, R, Jk)
}
}
\references{
Schouteden, M., Van Deun, K., Wilderjans, T. F., & Van Mechelen, I. (2014).
Performing DISCO-SCA to search for distinctive and common information in linked data.
Behavior research methods, 46(2), 576-587.
}
