% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{Main}
\alias{Main}
\title{Main}
\usage{
Main(
  mat.y,
  mat.x = NULL,
  trend = FALSE,
  intercept = TRUE,
  ci = c(0.9, 0.95, 0.99),
  est.mode = "OLS",
  iter = 3,
  aic.bic.mode = "AIC",
  q.max = 2,
  trim = 0.15,
  pos.break = FALSE
)
}
\arguments{
\item{mat.y}{The matrix object of time series}

\item{mat.x}{The matrix of optional covariates}

\item{trend}{Whether we add a trend. Default = FALSE}

\item{intercept}{Whether the break test is on the intercept only. Default = TRUE}

\item{ci}{A vector of confidence intervals. Default = c(0.9, 0.95, 0.99)}

\item{est.mode}{Estimation mode. Can be "OLS", "FGLS", or "IGLS"}

\item{iter}{Maximum number of iterations in the "IGLS" mode. Default to 3}

\item{aic.bic.mode}{Can be "AIC" or "BIC" depending on the criterion chosen for the lag selection}

\item{q.max}{Maximum lag tested for the AIC or BIC criterion}

\item{trim}{Percentage for the trim value for the starting and ending window over which the algorithm is not tested. Default to 15\%}

\item{pos.break}{Whether we want to select the maximum positive break only and discard the negative ones. Default to FALSE}
}
\value{
A list of the vector of f-statistics, the maximum f-statistic retained, the confidence interval, the critical values, the break date, the original matrix of time series tested, the matrix with breaking and not breaking covariates, the index of the break in the time series, the size of the break (mean.shift), the optimal "AIC" or "BIC", a ggplot object (g1), and the trimmed dates.
}
\description{
Entry point for the whole computation of the algorithm of Bai, Lumsdaine, and Stock (1998)
}
\examples{
\donttest{
data(example_data)
list.results <- Main(mat.y = example_data, q = 2)}
}
